package gov.va.genisis2.converter;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotSame;
import static org.junit.Assert.assertTrue;

import java.util.ArrayList;
import java.util.List;

import org.junit.Before;
import org.junit.Test;

import gov.va.genisis2.AbstractMockMvcTests;
import gov.va.genisis2.model.Source;
import gov.va.genisis2.util.Helper;

/**
 * 
 * @author Getaneh Kassahun
 * 
 */
public class SourceConverterTest extends AbstractMockMvcTests {

	private SourceConverter sourceConverter;

	@Before
	public void setUp() {
		sourceConverter = new SourceConverter();
	}

	@Test
	public void convert() {

		assertEquals("Survey", sourceConverter.convert(Helper.getNewSource()).getDescription());
		assertNotSame("Sur  vey", sourceConverter.convert(Helper.getNewSource()).getDescription());

	}

	@Test
	public void convert2() {

		assertEquals("Survey", sourceConverter.convert(Helper.getSourceDTO()).getDescription());
		assertNotSame("Sur  vey", sourceConverter.convert(Helper.getSourceDTO()).getDescription());

	}

	@Test
	public void convertSources() {

		List<Source> sources = new ArrayList<>();
		sources.add(Helper.getNewSource());
		assertTrue(!sourceConverter.convertSources(sources).isEmpty());
		assertFalse(sourceConverter.convertSources(sources).isEmpty());
	}

}
